/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.tiviacz.pizzacraft.blockentity.BaseBlockEntity;
import com.tiviacz.pizzacraft.init.ModAdvancements;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.recipes.mortar.MortarRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MortarAndPestleBlockEntity
extends BaseBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private int craftingProgress = 0;
    private final String CRAFTING_PROGRESS = "CraftingProgress";
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);

    public MortarAndPestleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.MORTAR_AND_PESTLE.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.craftingProgress = compound.m_128451_("CraftingProgress");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("CraftingProgress", this.craftingProgress);
    }

    public boolean canMix(Player player) {
        ++this.craftingProgress;
        if (this.craftingProgress % 2 == 0) {
            this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12450_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
        }
        if (this.craftingProgress >= 50) {
            this.resetProgress();
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)MortarRecipe.Type.MORTAR_AND_PESTLE_RECIPE_TYPE, (Container)new RecipeWrapper(this.getInventory()), this.f_58857_).isPresent();
    }

    public void mix(Level level, Player player) {
        int duration;
        Optional match = level.m_7465_().m_44015_((RecipeType)MortarRecipe.Type.MORTAR_AND_PESTLE_RECIPE_TYPE, (Container)new RecipeWrapper(this.getInventory()), level);
        if (match.isPresent() && this.craftingProgress == (duration = ((MortarRecipe)match.get()).getDuration())) {
            ItemStack result = ((MortarRecipe)match.get()).m_8043_().m_41777_();
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getInventory().getStackInSlot(0)), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.3, (double)this.m_58899_().m_123343_() + 0.5, 0.0, 0.0, 0.0);
            for (int i = 0; i < ((MortarRecipe)match.get()).getInputs().size(); ++i) {
                this.decrStackSize(this.getInventory(), i, 1);
            }
            level.m_5594_(player, this.m_58899_(), SoundEvents.f_12296_, SoundSource.BLOCKS, 0.7f, 0.8f);
            ItemEntity entity = new ItemEntity(level, (double)this.m_58899_().m_123341_() + 0.5 + (double)Direction.NORTH.m_122429_() * 0.2, (double)this.m_58899_().m_123342_() + 0.2, (double)this.m_58899_().m_123343_() + 0.5 + (double)Direction.NORTH.m_122431_() * 0.2, result.m_41777_());
            entity.m_20334_((double)((float)Direction.NORTH.m_122429_() * 0.2f), 0.0, (double)((float)Direction.NORTH.m_122431_() * 0.2f));
            level.m_7967_((Entity)entity);
            if (player instanceof ServerPlayer) {
                ModAdvancements.MORTAR_AND_PESTLE.trigger((ServerPlayer)player);
            }
            this.resetProgress();
        }
    }

    public void resetProgress() {
        this.craftingProgress = 0;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public void insertStack(int slot, Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            player.m_21008_(hand, this.getInventory().insertItem(slot, player.m_21120_(hand), false));
        } else {
            this.getInventory().insertItem(slot, player.m_21120_(hand).m_41777_(), false);
        }
        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
    }

    public void extractStack(int slot, Player player) {
        if (!player.m_7500_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.getInventory().extractItem(slot, 64, false));
        } else {
            this.getInventory().extractItem(slot, 64, false);
        }
        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MortarAndPestleBlockEntity.this.resetProgress();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

